<?php
// Check if db.json file exists, if not, create it
if (!file_exists('db.json')) {
    $initialTasks = [];
    $tasksData = json_encode($initialTasks);
    file_put_contents('db.json', $tasksData);
}

$tasksData = file_get_contents('db.json');
$tasks = json_decode($tasksData, true);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Baby's Todo List</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        .completed {
            text-decoration: line-through;
        }
        body {
            font-family: 'Comic Sans MS', cursive, sans-serif;
            background-color: #ffebcd;
            padding: 20px;
        }
        h1 {
            text-align: center;
            color: #ff69b4;
        }
        textarea {
            width: 100%;
            height: 100px;
            padding: 10px;
            box-sizing: border-box;
            font-size: 16px;
            resize: vertical;
            border: 2px solid #ff69b4;
            border-radius: 10px;
        }
        button {
            background-color: #ff69b4;
            color: white;
            padding: 10px 20px;
            border: none;
            cursor: pointer;
            border-radius: 5px;
        }
        ul {
            list-style-type: none;
            padding: 0;
        }
        li {
            background-color: #fff8dc;
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 10px;
            box-shadow: 0 2px 5px rgba(255, 105, 180, 0.3);
            display: flex;
            flex-direction: column;
            cursor: move;
            position: relative;
        }
        li span {
            margin-bottom: 10px;
        }
        li .button-container {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }
        .move-icon {
            position: absolute;
            top: 5px;
            right: 5px;
            font-size: 16px;
            color: #ff69b4;
        }
    </style>
</head>
<body>
    <h1>Baby's Todo List</h1>
    <textarea id="newTask" placeholder="Add a new task..."></textarea>
    <button onclick="addTask()">Add</button>
    <ul id="taskList"></ul>

    <script>
        let tasks = <?php echo json_encode($tasks); ?>;
        let draggedTask;

        function addTask() {
            let taskInput = document.getElementById("newTask");
            let taskText = taskInput.value.trim();
            if (taskText !== "") {
                let task = {
                    text: nl2br(taskText),
                    completed: false,
                    editing: false
                };
                tasks.unshift(task); // Add new task at the top
                taskInput.value = "";
                renderTasks();
                saveTasksToFile();
            }
        }

        function toggleTaskCompletion(index) {
            tasks[index].completed = !tasks[index].completed;
            renderTasks();
            saveTasksToFile();
        }

        function editTask(index) {
            tasks[index].editing = true;
            renderTasks();
        }

        function updateTask(index, newText) {
            tasks[index].text = nl2br(newText.trim());
            tasks[index].editing = false;
            renderTasks();
            saveTasksToFile();
        }

        function removeTask(index) {
            tasks.splice(index, 1);
            renderTasks();
            saveTasksToFile();
        }

        function renderTasks() {
            let taskList = document.getElementById("taskList");
            taskList.innerHTML = "";
            for (let i = 0; i < tasks.length; i++) {
                let task = tasks[i];
                let li = document.createElement("li");
                li.draggable = true;
                li.addEventListener("dragstart", dragStartHandler);
                li.addEventListener("dragover", dragOverHandler);
                li.addEventListener("drop", dropHandler);
                let taskText;
                if (task.editing) {
                    let editInput = document.createElement("textarea");
                    editInput.value = task.text.replace(/<br \/>/g, "\n");
                    editInput.addEventListener("blur", function() {
                        updateTask(i, editInput.value);
                    });
                    li.appendChild(editInput);
                } else {
                    taskText = document.createElement("span");
                    taskText.innerHTML = task.text;
                    li.appendChild(taskText);
                }
                let buttonContainer = document.createElement("div");
                buttonContainer.classList.add("button-container");
                if (task.completed) {
                    li.classList.add("completed");
                }
                let completeButton = document.createElement("button");
                completeButton.textContent = task.completed ? "Undo" : "Complete";
                completeButton.addEventListener("click", function() {
                    toggleTaskCompletion(i);
                });
                buttonContainer.appendChild(completeButton);
                let editButton = document.createElement("button");
                editButton.textContent = "Edit";
                editButton.addEventListener("click", function() {
                    editTask(i);
                });
                buttonContainer.appendChild(editButton);
                let removeButton = document.createElement("button");
                removeButton.textContent = "Remove";
                removeButton.addEventListener("click", function() {
                    removeTask(i);
                });
                buttonContainer.appendChild(removeButton);
                li.appendChild(buttonContainer);
                let moveIcon = document.createElement("span");
                moveIcon.classList.add("move-icon");
                moveIcon.textContent = "⥯";
                li.appendChild(moveIcon);
                taskList.appendChild(li);
            }
        }

        function nl2br(str) {
            return str.replace(/\n/g, "<br />");
        }

        function saveTasksToFile() {
            let tasksData = JSON.stringify(tasks);
            let xhr = new XMLHttpRequest();
            xhr.open("POST", "", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    console.log("Tasks saved successfully.");
                }
            };
            xhr.send("tasks=" + encodeURIComponent(tasksData));
        }

        function dragStartHandler(e) {
            draggedTask = e.target;
            e.dataTransfer.effectAllowed = "move";
            e.dataTransfer.setData("text/html", null);
        }

        function dragOverHandler(e) {
            e.preventDefault();
            e.dataTransfer.dropEffect = "move";
        }

        function dropHandler(e) {
            e.preventDefault();
            let target = e.target.closest("li");
            let targetIndex = Array.from(target.parentNode.children).indexOf(target);
            let draggedIndex = Array.from(target.parentNode.children).indexOf(draggedTask);
            if (targetIndex !== draggedIndex) {
                tasks.splice(targetIndex, 0, tasks.splice(draggedIndex, 1)[0]);
                renderTasks();
                saveTasksToFile();
            }
        }

        renderTasks();
    </script>
</body>
</html>

<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $tasksData = $_POST['tasks'];
    file_put_contents('db.json', $tasksData);
}
?>